<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Mail Driver
    |--------------------------------------------------------------------------
    |
    | Laravel supports both SMTP and PHP's "mail" function as drivers for the
    | sending of e-mail. You may specify which one you're using throughout
    | your application here. By default, Laravel is setup for SMTP mail.
    |
    | Supported: "smtp", "mail", "sendmail", "mailgun", "mandrill", "log"
    |
    */

    'driver' => 'smtp',

    /*
    |--------------------------------------------------------------------------
    | SMTP Host Address
    |--------------------------------------------------------------------------
    |
    | Here you may provide the host address of the SMTP server used by your
    | applications. A default option is provided that is compatible with
    | the Mailgun mail service which will provide reliable deliveries.
    |
    */

    'host' => 'localhost',

    /*
    |--------------------------------------------------------------------------
    | SMTP Host Port
    |--------------------------------------------------------------------------
    |
    | This is the SMTP port used by your application to deliver e-mails to
    | users of the application. Like the host we have set this value to
    | stay compatible with the Mailgun e-mail application by default.
    |
    */

    'port' => 465,

    /*
    |--------------------------------------------------------------------------
    | Global "From" Address
    |--------------------------------------------------------------------------
    |
    | You may wish for all e-mails sent by your application to be sent from
    | the same address. Here, you may specify a name and address that is
    | used globally for all e-mails that are sent by your application.
    |
    */

    'from' => ['address' => null, 'name' => null],

    /*
    |--------------------------------------------------------------------------
    | E-Mail Encryption Protocol
    |--------------------------------------------------------------------------
    |
    | Here you may specify the encryption protocol that should be used when
    | the application send e-mail messages. A sensible default using the
    | transport layer security protocol should provide great security.
    |
    */

    'encryption' => 'ssl',

    /*
    |--------------------------------------------------------------------------
    | SMTP Server Username
    |--------------------------------------------------------------------------
    |
    | If your SMTP server requires a username for authentication, you should
    | set it here. This will get used to authenticate with your server on
    | connection. You may also set the "password" value below this one.
    |
    */

    'username' => '',

    /*
    |--------------------------------------------------------------------------
    | SMTP Server Password
    |--------------------------------------------------------------------------
    |
    | Here you may set the password required by your SMTP server to send out
    | messages from your application. This will be given to the server on
    | connection so that the application will be able to send messages.
    |
    */

    'password' => '',

    /*
    |--------------------------------------------------------------------------
    | SMTP Local Domain
    |--------------------------------------------------------------------------
    |
    | Set your servers hostname, which will be used in the EHLO statement
    | to the SMTP server. Defaults to $_SERVER['SERVER_NAME'] or "[127.0.0.1]"
    | when the previous value is unavailable (such as CLI).
    |
    */

    'local_domain' => null,

    /*
    |--------------------------------------------------------------------------
    | SMTP Socket Address
    |--------------------------------------------------------------------------
    |
    | Used to specify the IP address (either IPv4 or IPv6) and/or the port
    | number that PHP will use to access the network. The syntax is ip:port for
    | IPv4 addresses, and [ip]:port for IPv6 addresses.
    | See https://www.php.net/manual/en/context.socket.php
    |
    */

    'source_ip' => null,

    /*
    |--------------------------------------------------------------------------
    | SMTP Server Timeout
    |--------------------------------------------------------------------------
    |
    | The number of seconds that the system should wait for a response
    | before timing out.
    |
    */

    'timeout' => env('MAIL_TIMEOUT', 15),

    /*
    |--------------------------------------------------------------------------
    | Sendmail System Path
    |--------------------------------------------------------------------------
    |
    | When using the "sendmail" driver to send e-mails, we will need to know
    | the path to where Sendmail lives on this server. A default path has
    | been provided here, which will work well on most of your systems.
    |
    */

    'sendmail' => '/usr/sbin/sendmail -bs',

    /*
    |--------------------------------------------------------------------------
    | Mail "Pretend"
    |--------------------------------------------------------------------------
    |
    | When this option is enabled, e-mail will not actually be sent over the
    | web and will instead be written to your application's logs files so
    | you may inspect the message. This is great for local development.
    |
    */

    'pretend' => false,

    /*
    |--------------------------------------------------------------------------
    | Security Policy
    |--------------------------------------------------------------------------
    |
    | All outbound emails are bound to the below security policy. This governs
    | what is possible from within e-mail templates and ensure that rogue
    | staff members do not result in a security risk.
    |
    */

    'policy' => [

        // Twig Tags - http://twig.sensiolabs.org/doc/tags/index.html
        'tags' => [ 'if', 'else', 'for', 'set' ],

        // Twig Filters - http://twig.sensiolabs.org/doc/filters/index.html
        'filters' => [ 'join', 'escape', 'default', 'merge', 'date', 'raw', 'json_encode', 'addslashes', 'capitalize' ],

        // Methods / functions that can be called on given objects.
        'methods' => [
            'App\Modules\Core\Models\CustomFieldValue'  => [ 'format' ],
            'App\Modules\Selfservice\Models\Article'  => [ 'url', 'frontendUrl', 'internalUrl' ],
            'Illuminate\Support\Collection' => [
                'all', 'average', 'avg', 'chunk', 'collapse', 'combine', 'concat', 'contains', 'containsStrict',
                'count', 'countBy', 'crossJoin', 'diff', 'diffAssoc', 'diffKeys', 'duplicates', 'duplicatesStrict',
                'each', 'eachSpread', 'every', 'except', 'filter', 'first', 'firstWhere', 'flatMap', 'flatten', 'flip',
                'forget', 'forPage', 'get', 'groupBy', 'has', 'implode', 'intersect', 'intersectByKeys', 'isEmpty',
                'isNotEmpty', 'join', 'keyBy', 'keys', 'last', 'macro', 'make', 'map', 'mapInto', 'mapSpread',
                'mapToGroups', 'mapWithKeys', 'max', 'median', 'merge', 'mergeRecursive', 'min', 'mode', 'nth', 'only',
                'pad', 'partition', 'pipe', 'pluck', 'pop', 'prepend', 'pull', 'push', 'put', 'random', 'reduce',
                'reject', 'replace', 'replaceRecursive', 'reverse', 'search', 'shift', 'shuffle', 'skip', 'slice',
                'some', 'sort', 'sortBy', 'sortByDesc', 'sortKeys', 'sortKeysDesc', 'splice', 'split', 'sum', 'take',
                'tap', 'times', 'toArray', 'toJson', 'transform', 'union', 'unique', 'uniqueStrict', 'unless',
                'unlessEmpty', 'unlessNotEmpty', 'unwrap', 'values', 'when', 'whenEmpty', 'whenNotEmpty', 'where',
                'whereStrict', 'whereBetween', 'whereIn', 'whereInStrict', 'whereNotBetween', 'whereNotIn',
                'WhereNotInStrict', 'whereNotNull', 'whereNull', 'wrap', 'zip'
            ],
            'TwigBridge\Extension\Loader\Facade\Caller' => [ 'clean' ],
            'App\Auth\Guards\SessionGuard' => ['check', 'user'],
        ],

        // Properties that can be accessed from given object types.
        'properties' => [
            // General
            'stdClass'                                          => [
                'name', 'default_email', 'frontend_url', 'waiting_response_time', 'inactive_close_time'
            ],

            // Private Messages
            'App\Modules\Core\Models\PrivateMessage'            => [
                'user', 'purified_message'
            ],

            // Core
            'App\Modules\Core\Models\Brand'                     => [
                'id', 'name', 'system_url', 'brand_colour', 'favicon', 'frontend_logo', 'frontend_logo_dark_mode',
                'frontend_url', 'website_url', 'operator_icon', 'default_email', 'global_email_header',
                'global_email_footer', 'default_country', 'default_timezone', 'default_language', 'date_format',
                'time_format',
            ],
            'App\Modules\Core\Models\IpBan'                     => [
                'id', 'ip', 'operator_edit_url'
            ],
            'App\Modules\Core\Models\Upload'                    => [
                'id', 'hash', 'filename', 'folder', 'size', 'mime'
            ],

            // Selfservice
            'App\Modules\Selfservice\Models\Article'            => [
                'title', 'excerpt', 'created_at', 'updated_at', 'author', 'purified_text',
            ],
            'App\Modules\Selfservice\Models\Comment'            => [
                'purified_text', 'created_at', 'updated_at', 'article', 'type', 'author', 'operator_edit_url',
            ],

            // Tickets
            'App\Modules\Ticket\Models\Attachment'              => [
                'id', 'ticket_id', 'message_id', 'upload_hash', 'original_name', 'direct_frontend_url',
                'direct_operator_url', 'frontend_url', 'operator_url', 'upload',
            ],
            'App\Modules\Ticket\Models\Ticket'                  => [
                'id', 'number', 'token', 'department_id', 'department', 'department_email_id', 'departmentEmail',
                'brand_id', 'brand', 'channel_id', 'channel', 'user_id', 'user', 'status_id', 'status', 'priority_id',
                'priority', 'sla_plan_id', 'slaplan', 'subject', 'due_time', 'resolved_time', 'cc', 'locked', 'merged',
                'internal', 'messages_count', 'notes_count', 'has_attachments', 'has_draft', 'created_at', 'updated_at',
                'lastReply', 'frontend_url', 'operator_url', 'tags', 'assigned', 'customfields', 'messages',
                'lastMessage', 'firstMessage',
            ],
            'App\Modules\Ticket\Models\Message'                 => [
                'id', 'ticket_id', 'ticket', 'channel_id', 'channel', 'user_id', 'user', 'user_name', 'user_ip_address',
                'by', 'type', 'excerpt', 'purified_text', 'is_draft', 'extra', 'created_at', 'updated_at', 'attachments'
            ],
            'App\Modules\Ticket\Models\Channel'                 => [ 'id', 'name' ],
            'App\Modules\Ticket\Models\Department'              => [
                'id', 'name', 'frontend_name', 'description', 'disable_user_email_replies'
            ],
            'App\Modules\Ticket\Models\Status'                  => [ 'id', 'name', 'colour' ],
            'App\Modules\Ticket\Models\Priority'                => [ 'id', 'name', 'colour' ],
            'App\Modules\Ticket\Models\SlaPlan'                 => [ 'id', 'name' ],
            'App\Modules\Ticket\Models\Tag'                     => [ 'name' ],
            'App\Modules\Ticket\Models\TicketCustomField'       => [
                'id', 'name', 'type', 'required', 'public', 'encrypted', 'purge', 'locked', 'options'
            ],
            'App\Modules\Ticket\Models\TicketCustomFieldOption' => [ 'id', 'field_id', 'value' ],
            'App\Modules\Ticket\Models\TicketCustomFieldValue'  => [ 'id', 'field_id', 'ticket_id', 'value', 'field' ],

            // User
            'App\Modules\User\Models\User'                      => [
                'id', 'brand_id', 'role', 'formatted_name', 'firstname', 'lastname', 'email', 'confirmed', 'country',
                'organisation_id', 'organisation', 'organisation_access_level', 'organisation_notifications', 'country',
                'language_code', 'timezone', 'avatar', 'avatar_url', 'notes', 'last_active_at', 'created_at',
                'updated_at', 'groups', 'customfields', 'reply_template', 'active',
            ],
            'App\Modules\User\Models\UserOrganisation' => [
                'id', 'brand_id', 'brand', 'owner_id', 'owner', 'name', 'country', 'language_code', 'timezone', 'notes',
                'users', 'customfields'
            ],
            'App\Modules\User\Models\UserGroup'                 => [
                'id', 'name', 'description', 'colour', 'administrator'
            ],
            'App\Modules\User\Models\UserCustomField'           => [
                'id', 'name', 'type', 'required', 'public', 'encrypted', 'locked', 'options'
            ],
            'App\Modules\User\Models\UserCustomFieldOption'     => [ 'id', 'field_id', 'value' ],
            'App\Modules\User\Models\UserCustomFieldValue'      => [ 'id', 'field_id', 'user_id', 'value', 'field' ],
            'App\Modules\User\Models\UserOrganisationCustomFieldOption' => [ 'id', 'field_id', 'value' ],
            'App\Modules\User\Models\UserOrganisationCustomFieldValue'  => [
                'id', 'field_id', 'organisation_id', 'value', 'field'
            ],
        ],

        // Global functions, see config/twigbridge.php for function declarations.
        'functions' => [
            'formatDate', 'route', 'mail_route', 'get_logo', 'floor', 'is_gt', 'is_lt', 'json_decode', 'implode',
            'constant', 'auth_user', 'auth_check',
        ],

    ],

    /*
    |--------------------------------------------------------------------------
    | Clipping Delimiter
    |--------------------------------------------------------------------------
    |
    | Character sequence wrapped around "Please respond above this line"
    | message added to the start of all ticket emails. Used to identify the end
    | of replies via email by searching for a HTML node that starts and ends
    | with the character sequence.
    |
    | Take extreme care when editing as replies via the email channel may not
    | be clipped or may be clipped incorrectly.
    |
    | Valid characters: alphanumeric, dashes, hashes, exclamation marks.
    |
    */

    'delimiter' => '-#-#-',

    /*
    |--------------------------------------------------------------------------
    | Reply Line
    |--------------------------------------------------------------------------
    |
    | The "Please reply above this line" message added to the start of ticket
    | emails generated by SupportPal.
    |
    | The %s inside a HTML node is REQUIRED for clipping replies via email. It
    | is automatically replaced by "mail.delimiter Please reply above this line
    | mail.delimiter". The language variable can be found in the language file
    | resources\lang\*\ticket.php under key "reply_above_line".
    |
    | Set to an empty string to completely remove reply line. This means
    | replies via the email channel will not be clipped.
    |
    */

    'reply_line' => '<em style="color: #999;">%s</em><br /><br />',

    /*
     |--------------------------------------------------------------------------
     | SwiftMailer Cache Type.
     |--------------------------------------------------------------------------
     |
     | Set the type of cache to use (i.e. "disk" or "array").
     |
     */

    'cache_type' => env('MAILER_CACHE_TYPE', 'disk'),

];
