<?php declare(strict_types=1);

use SupportPal\Purifier\Injector\LazyImageLoading;

return [
    'settings' => [
        'default' => [
            'Attr.EnableID'             => true,
            'Attr.AllowedFrameTargets'  => ['_blank'],
            'AutoFormat.AutoParagraph'  => false,
            'AutoFormat.Linkify'        => true,
            'Core.AllowParseManyTags'   => true,
            'CSS.AllowTricky'           => true,
            'CSS.Proprietary'           => true,
            'HTML.IframeAllowFullscreen' => true,
            'HTML.SafeIframe'           => 'true',
            'HTML.TidyAdd'              => 'font',
            'URI.AllowedSchemes'        => [
                'http'      => true,
                'https'     => true,
                'mailto'    => true,
                'ftp'       => true,
                'nntp'      => true,
                'news'      => true,
                'data'      => true,
            ],
            'URI.SafeIframeRegexp'      => '%^(http://|https://|//)(www.youtube.com/embed/|player.vimeo.com/video/)%',
        ],
        'selfservice' => [
            'AutoFormat.Linkify'        => true,
            'Attr.EnableID'             => true,
            'HTML.TargetNoreferrer'     => false, // If we don't disable this, referral links will not work.
        ],
        'ticket' => [
            'Attr.AllowedClasses' => [
                // Email channel: wrap quoted html classes.
                'expandable',
                'supportpal_quote',
                // body_class of editor_config.js
                'sp-editor-content',
                // Classes used in tinymce-published.css
                'moz-signature',
                // Mentions
                'sp-mention',
            ],
            'AutoFormat.Custom'   => [new LazyImageLoading],
        ]
    ],
    'encoding'  => 'UTF-8',
];
