<?php

use App\Modules\User\Controllers\Saml\SamlAuthManager;

return [

    /*
     |----------------------------------------------------------------
     | Strict Mode
     |----------------------------------------------------------------
     |
     | If 'strict' is True, then the PHP Toolkit will reject unsigned
     | or unencrypted messages if it expects them signed or encrypted
     | Also will reject the messages if not strictly follow the SAML
     | standard: Destination, NameId, Conditions ... are validated too.
     |
     */

    'strict' => true,

    /*
     |--------------------------------------------------------------------------
     | SAML Manager
     |--------------------------------------------------------------------------
     |
     | Define different SAML authentication settings for the frontend and
     | operator panels. Defining an IdP will enable SAML for the respective
     | panel.
     |
     */

    'guards' => [

        SamlAuthManager::FRONTEND_GUARD => [

        ],

        SamlAuthManager::OPERATOR_GUARD => [

        ],

    ],

];
