<?php

return array(

    /*
    |--------------------------------------------------------------------------
    | Themes
    |--------------------------------------------------------------------------
    |
    | This option allows you to override the default colours of the light and
    | dark themes. We recommend to use the Settings > General > Brands brand
    | colour setting if you only want to override the primary colours. Setting
    | a brand colour will override the below primary colours and updating
    | these values will have no effect.
    |
    */

    'themes' => array(
        'light' => array(
            'selector' => ':root',
            'scheme' => array(
                '--color-primary-100' => '#bbdefb',
                '--color-primary-200' => '#90caf9',
                '--color-primary-300' => '#64b5f6',
                '--color-primary-400' => '#42a5f5',
                '--color-primary-500' => '#2196f3',
                '--color-primary-600' => '#1e88e5',
                '--color-primary-700' => '#1976d2',
                '--color-primary-800' => '#1565c0',
                '--color-primary-900' => '#0d47a1',

                '--color-background-primary'   => '#ffffff',
                '--color-background-secondary' => '#edf2f7',
                '--color-background-tertiary'  => '#e2e8f0',

                '--color-text-primary'   => '#2d3748',
                '--color-text-secondary' => '#718096',
                '--color-text-tertiary'  => '#a0aec0',
            )
        ),
        'dark' => array(
            'selector' => '.sp-theme-dark',
            'scheme' => array(
                '--color-primary-100' => '#90a4ae',
                '--color-primary-200' => '#78909c',
                '--color-primary-300' => '#607d8b',
                '--color-primary-400' => '#546e7a',
                '--color-primary-500' => '#455a64',
                '--color-primary-600' => '#37474f',
                '--color-primary-700' => '#263238',
                '--color-primary-800' => '#102027',
                '--color-primary-900' => '#000a12',

                '--color-background-primary'   => '#263238',
                '--color-background-secondary' => '#37474f',
                '--color-background-tertiary'  => '#455a64',

                '--color-text-primary'   => '#e2f1f8',
                '--color-text-secondary' => '#c1d5e0',
                '--color-text-tertiary'  => '#718096',
            )
        )
    ),

);
