<?php
/**
 * Activity Log Table Migration
 *
 * @package    Database\Migrations\v2_0_0\Beta1\Core
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.0
 */
namespace Database\Migrations\v2_0_0\Beta1\Core;

use DB;
use Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Class CreateActivityLogTable
 *
 * @package    Database\Migrations\v2_0_0\Beta1\Core
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.0
 */
class CreateActivityLogTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('activity_log', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->charset = 'utf8';
            $table->collation = 'utf8_unicode_ci';

            $table->increments('id')->unsigned();
            $table->smallInteger('type');

            $table->string('rel_name')->nullable();
            $table->integer('rel_id')->unsigned()->nullable();
            $table->string('rel_route')->nullable();
            $table->string('section')->nullable();

            $table->integer('user_id')->unsigned()->nullable();
            $table->foreign('user_id')->references('id')->on('user')->onDelete('set null');
            $table->string('user_name')->nullable();

            $table->string('event_name')->nullable();
            $table->text('event_text')->nullable();

            $table->string('old_value')->nullable();
            $table->string('new_value')->nullable();

            $table->integer('created_at');
            $table->integer('updated_at')->default(0);

            $table->index([ 'type', 'rel_id', 'section' ]);
        });

        DB::statement('ALTER TABLE `activity_log` ADD `ip` VARBINARY(16) AFTER `new_value`;');
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        Schema::drop('activity_log');
        DB::statement('SET FOREIGN_KEY_CHECKS=1;');
    }
}
