<?php
/**
 * IP Whitelist Table Migration
 *
 * @package    Database\Migrations\v2_0_0\Beta1\Core
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.0
 */
namespace Database\Migrations\v2_0_0\Beta1\Core;

use DB;
use Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Class CreateIpWhitelistTable
 *
 * @package    Database\Migrations\v2_0_0\Beta1\Core
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.0
 */
class CreateIpWhitelistTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('ip_whitelist', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->charset = 'utf8';
            $table->collation = 'utf8_unicode_ci';

            $table->increments('id')->unsigned();

            $table->string('description')->nullable();
            $table->tinyInteger('event_user')->default(1);
            $table->tinyInteger('event_operator')->default(1);
            $table->tinyInteger('event_api')->default(1);
            $table->integer('created_at');
            $table->integer('updated_at')->default(0);
        });

        DB::statement('ALTER TABLE `ip_whitelist` ADD `ip` VARBINARY(16) AFTER `id`;');
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        Schema::drop('ip_whitelist');
        DB::statement('SET FOREIGN_KEY_CHECKS=1;');
    }
}
