<?php
/**
 * Email Log Table Migration
 *
 * @package    Database\Migrations\v2_0_0\Beta1\Core
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.0
 */
namespace Database\Migrations\v2_0_0\Beta1\Core;

use DB;
use Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Class CreateEmailLogTable
 *
 * @package    Database\Migrations\v2_0_0\Beta1\Core
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.0
 */
class CreateEmailLogTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('email_log', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->charset = 'utf8';
            $table->collation = 'utf8_unicode_ci';

            $table->increments('id')->unsigned();
            $table->smallInteger('type');

            $table->string('to');
            $table->string('cc')->nullable();

            $table->string('from_address');
            $table->string('from_name')->nullable();
            $table->integer('from_user_id')->unsigned()->nullable();
            $table->foreign('from_user_id')->references('id')->on('user')->onDelete('set null');

            $table->string('subject');
            $table->mediumText('contents');
            $table->mediumText('raw')->nullable();

            $table->integer('message_id')->unsigned()->nullable();
            $table->foreign('message_id')->references('id')->on('ticket_message')->onDelete('set null');

            $table->integer('created_at');
            $table->integer('updated_at')->default(0);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        Schema::drop('email_log');
        DB::statement('SET FOREIGN_KEY_CHECKS=1;');
    }
}
