<?php
/**
 * Operator Widget Table Migration
 *
 * @package    Database\Migrations\v2_0_0\Beta1\Core
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.0
 */
namespace Database\Migrations\v2_0_0\Beta1\Core;

use DB;
use Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Class CreateOperatorWidgetTable
 *
 * @package    Database\Migrations\v2_0_0\Beta1\Core
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.0
 */
class CreateOperatorWidgetTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('operator_widget', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->charset = 'utf8';
            $table->collation = 'utf8_unicode_ci';

            $table->increments('id')->unsigned();

            $table->integer('user_id')->unsigned();
            $table->foreign('user_id')->references('id')->on('user')->onDelete('cascade');

            $table->string('widget_id');
            $table->foreign('widget_id')->references('id')->on('widget')->onDelete('cascade');

            $table->tinyInteger('enabled')->default(1);

            $table->tinyInteger('column')->nullable();
            $table->tinyInteger('order')->nullable();
            $table->tinyInteger('minimised')->default(0);


            $table->integer('created_at');
            $table->integer('updated_at')->default(0);
        });

        DB::statement('ALTER TABLE `operator_widget` ADD UNIQUE `unique_index`(`user_id`, `widget_id`);');
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        Schema::drop('operator_widget');
        DB::statement('SET FOREIGN_KEY_CHECKS=1;');
    }
}
