<?php
/**
 * Article Type Table Migration
 *
 * @package    Database\Migrations\v2_0_0\Beta1\Selfservice
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.0
 */
namespace Database\Migrations\v2_0_0\Beta1\Selfservice;

use DB;
use Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Class CreateArticleTypeTable
 *
 * @package    Database\Migrations\v2_0_0\Beta1\Selfservice
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.0
 */
class CreateArticleTypeTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('article_type', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->charset = 'utf8';
            $table->collation = 'utf8_unicode_ci';

            $table->increments('id')->unsigned();

            $table->string('name', 45);
            $table->string('slug', 45)->unique();
            $table->string('description');

            $table->mediumInteger('order')->nullable();
            $table->tinyInteger('enabled')->default(1);

            $table->tinyInteger('view')->default(0)->comment('0 - Hierarchical, 1 - List');
            $table->binary('icon');
            $table->tinyInteger('show_on_dashboard')->default(1);

            $table->integer('created_at');
            $table->integer('updated_at')->default(0);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        Schema::drop('article_type');
        DB::statement('SET FOREIGN_KEY_CHECKS=1;');
    }
}
