<?php
/**
 * Article Table Migration
 *
 * @package    Database\Migrations\v2_0_0\Beta1\Selfservice
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.0
 */
namespace Database\Migrations\v2_0_0\Beta1\Selfservice;

use DB;
use Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Class CreateArticleTable
 *
 * @package    Database\Migrations\v2_0_0\Beta1\Selfservice
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.0
 */
class CreateArticleTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('article', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->charset = 'utf8';
            $table->collation = 'utf8_unicode_ci';

            $table->increments('id')->unsigned();
            $table->integer('type_id')->unsigned();
            $table->foreign('type_id')->references('id')->on('article_type')->onDelete('cascade');

            $table->integer('author_id')->unsigned();
            $table->foreign('author_id')->references('id')->on('user')->onDelete('cascade');

            $table->string('title');
            $table->string('slug');
            $table->string('keywords')->nullable()->comment('Comma delimited list');
            $table->mediumText('excerpt')->nullable();
            $table->longText('text');

            $table->integer('views')->nullable()->default(0);
            $table->integer('positive_rating')->default(0);
            $table->integer('total_rating')->default(0);

            $table->tinyInteger('published')->default(0)->comment('0 = Draft, 1 = Published');
            $table->tinyInteger('protected')->default(0)->comment('0 = Public, 1 = Registered Users Only');

            $table->integer('created_at');
            $table->integer('updated_at')->default(0);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        Schema::drop('article');
        DB::statement('SET FOREIGN_KEY_CHECKS=1;');
    }
}
