<?php
/**
 * Article Category Table Migration
 *
 * @package    Database\Migrations\v2_0_0\Beta1\Selfservice
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.0
 */
namespace Database\Migrations\v2_0_0\Beta1\Selfservice;

use DB;
use Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Class CreateArticleCategoryTable
 *
 * @package    Database\Migrations\v2_0_0\Beta1\Selfservice
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.0
 */
class CreateArticleCategoryTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('article_category', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->charset = 'utf8';
            $table->collation = 'utf8_unicode_ci';

            $table->increments('id')->unsigned();
            $table->integer('type_id')->unsigned();
            $table->foreign('type_id')->references('id')->on('article_type')->onDelete('cascade');

            $table->integer('parent_id')->unsigned()->nullable();
            $table->foreign('parent_id')->references('id')->on('article_category')->onDelete('cascade');

            $table->string('name', 45);
            $table->string('slug', 45);

            $table->tinyInteger('public')->default(0)->comment('0 = Not publicly accessible, 1 = accessibile');
            $table->tinyInteger('parent_public')->default(0)->comment('The visibility of parent(s)');

            $table->integer('created_at');
            $table->integer('updated_at')->default(0);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        Schema::drop('article_category');
        DB::statement('SET FOREIGN_KEY_CHECKS=1;');
    }
}
