<?php
/**
 * Comment Table Migration
 *
 * @package    Database\Migrations\v2_0_0\Beta1\Selfservice
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.0
 */
namespace Database\Migrations\v2_0_0\Beta1\Selfservice;

use DB;
use Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Class CreateCommentTable
 *
 * @package    Database\Migrations\v2_0_0\Beta1\Selfservice
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.0
 */
class CreateCommentTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('comment', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->charset = 'utf8';
            $table->collation = 'utf8_unicode_ci';

            $table->increments('id')->unsigned();

            $table->integer('article_id')->unsigned();
            $table->foreign('article_id')->references('id')->on('article')->onDelete('cascade');

            $table->integer('author_id')->unsigned();
            $table->foreign('author_id')->references('id')->on('user')->onDelete('cascade');

            $table->text('text');
            $table->integer('parent_id')->unsigned()->nullable()->default(null);
            $table->foreign('parent_id')->references('id')->on('comment')->onDelete('cascade');

            $table->integer('root_parent_id')->unsigned()->nullable();
            $table->foreign('root_parent_id')->references('id')->on('comment')->onDelete('cascade');

            $table->integer('rating')->default(0);
            $table->tinyInteger('status')->default(0)->comment('PENDING, APPROVED, SPAM');

            $table->tinyInteger('notify_reply')->default(0);

            $table->integer('created_at');
            $table->integer('updated_at')->default(0);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        Schema::drop('comment');
        DB::statement('SET FOREIGN_KEY_CHECKS=1;');
    }
}
