<?php
/**
 * Ticket Message Table Migration
 *
 * @package    Database\Migrations\v2_0_0\Beta1\Ticket
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.0
 */
namespace Database\Migrations\v2_0_0\Beta1\Ticket;

use DB;
use Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Class CreateTicketMessageTable
 *
 * @package    Database\Migrations\v2_0_0\Beta1\Ticket
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.0
 */
class CreateTicketMessageTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('ticket_message', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->charset = 'utf8';
            $table->collation = 'utf8_unicode_ci';

            $table->increments('id')->unsigned();
            $table->integer('ticket_id')->unsigned();
            $table->foreign('ticket_id')->references('id')->on('ticket')->onDelete('cascade');

            $table->integer('channel_id')->unsigned();
            $table->foreign('channel_id')->references('id')->on('ticket_channel')->onDelete('cascade');

            $table->integer('user_id')->unsigned();
            $table->foreign('user_id')->references('id')->on('user')->onDelete('cascade');

            $table->tinyInteger('by');
            $table->tinyInteger('type')->default(0);

            $table->longText('text');

            $table->tinyInteger('is_draft')->default(0);

            $table->string('social_id')->nullable();

            $table->integer('created_at');
            $table->integer('updated_at')->default(0);
        });

        DB::statement('ALTER TABLE `ticket_message` ADD `user_ip_address` VARBINARY(16) AFTER `user_id`;');
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        Schema::drop('ticket_message');
        DB::statement('SET FOREIGN_KEY_CHECKS=1;');
    }
}
