<?php
/**
 * Department Email Table Migration
 *
 * @package    Database\Migrations\v2_0_0\Beta1\Ticket
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.0
 */
namespace Database\Migrations\v2_0_0\Beta1\Ticket;

use DB;
use Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Class CreateDepartmentEmailTable
 *
 * @package    Database\Migrations\v2_0_0\Beta1\Ticket
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.0
 */
class CreateDepartmentEmailTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('department_email', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->charset = 'utf8';
            $table->collation = 'utf8_unicode_ci';

            $table->increments('id')->unsigned();
            $table->integer('department_id')->unsigned();
            $table->foreign('department_id')->references('id')->on('department')->onDelete('cascade');

            $table->string('address');
            $table->smallInteger('type')->default(0);
            $table->tinyInteger('protocol')->nullable();
            $table->string('server')->nullable();
            $table->string('username', 45)->nullable();
            $table->string('password')->nullable();
            $table->string('port', 5)->nullable();
            $table->smallInteger('encryption')->nullable();
            $table->tinyInteger('consume_all')->nullable();
            $table->tinyInteger('delete_downloaded')->nullable();

            $table->integer('created_at');
            $table->integer('updated_at')->default(0);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        Schema::drop('department_email');
        DB::statement('SET FOREIGN_KEY_CHECKS=1;');
    }
}
