<?php
/**
 * Schedule Hours Table Migration
 *
 * @package    Database\Migrations\v2_0_0\Beta1\Ticket
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.0
 */
namespace Database\Migrations\v2_0_0\Beta1\Ticket;

use DB;
use Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Class CreateScheduleHoursTable
 *
 * @package    Database\Migrations\v2_0_0\Beta1\Ticket
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.0
 */
class CreateScheduleHoursTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('schedule_hours', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->charset = 'utf8';
            $table->collation = 'utf8_unicode_ci';

            $table->increments('id')->unsigned();
            $table->integer('schedule_id')->unsigned();
            $table->foreign('schedule_id')->references('id')->on('schedule')->onDelete('cascade');

            $table->smallInteger('day')->comment('1 for Monday to 7 for Sunday');
            $table->smallInteger('type')->comment('0 or closed, 1 for 24 hours and 2 for custom');
            $table->smallInteger('start_hour')->nullable();
            $table->smallInteger('start_minute')->nullable();
            $table->smallInteger('end_hour')->nullable();
            $table->smallInteger('end_minute')->nullable();

            $table->integer('created_at');
            $table->integer('updated_at')->default(0);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        Schema::drop('schedule_hours');
        DB::statement('SET FOREIGN_KEY_CHECKS=1;');
    }
}
