<?php
/**
 * User Organisation Table Migration
 *
 * @package    Database\Migrations\v2_0_0\Beta1\User
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.0
 */
namespace Database\Migrations\v2_0_0\Beta1\User;

use DB;
use Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Class CreateUserOrganisationTable
 *
 * @package    Database\Migrations\v2_0_0\Beta1\User
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.0
 */
class CreateUserOrganisationTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('user_organisation', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->charset = 'utf8';
            $table->collation = 'utf8_unicode_ci';

            $table->increments('id')->unsigned();
            $table->integer('owner_id')->unsigned()->nullable();

            $table->string('name', 45);
            $table->string('address')->nullable();
            $table->string('city')->nullable();
            $table->string('state')->nullable();
            $table->string('postcode')->nullable();
            $table->string('country', 5)->nullable();
            $table->string('phone')->nullable();
            $table->string('website')->nullable();
            
            $table->string('language_code', 5)->nullable();
            $table->foreign('language_code')->references('code')->on('language')->onDelete('set null');
            $table->string('timezone')->nullable();

            $table->mediumText('notes')->nullable();

            $table->integer('created_at');
            $table->integer('updated_at')->default(0);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        Schema::drop('user_organisation');
        DB::statement('SET FOREIGN_KEY_CHECKS=1;');
    }
}
