<?php
/**
 * Permission Table Migration
 *
 * @package    Database\Migrations\v2_0_0\Beta1\User
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.0
 */
namespace Database\Migrations\v2_0_0\Beta1\User;

use DB;
use Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Class CreatePermissionTable
 *
 * @package    Database\Migrations\v2_0_0\Beta1\User
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.0
 */
class CreatePermissionTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('permission', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->charset = 'utf8';
            $table->collation = 'utf8_unicode_ci';

            $table->increments('id')->unsigned();
            $table->integer('inherit_id')->unsigned()->nullable();
            $table->foreign('inherit_id')->references('id')->on('permission')->onDelete('cascade');

            $table->integer('module_id')->unsigned();
            $table->foreign('module_id')->references('id')->on('module')->onDelete('cascade');

            $table->string('name');
            $table->string('slug');
            $table->text('description')->nullable();

            $table->integer('created_at');
            $table->integer('updated_at')->default(0);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        Schema::drop('permission');
        DB::statement('SET FOREIGN_KEY_CHECKS=1;');
    }
}
