<?php
/**
 * User Table Migration
 *
 * @package    Database\Migrations\v2_0_0\Beta1\User
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.0
 */
namespace Database\Migrations\v2_0_0\Beta1\User;

use DB;
use Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Class CreateUserTable
 *
 * @package    Database\Migrations\v2_0_0\Beta1\User
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.0
 */
class CreateUserTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('user', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->charset = 'utf8';
            $table->collation = 'utf8_unicode_ci';

            $table->increments('id')->unsigned();
            $table->string('firstname', 45)->nullable();
            $table->string('lastname', 45)->nullable();
            $table->string('email')->nullable()->unique();
            $table->string('password', 60)->nullable();
            $table->string('session')->nullable();
            $table->string('remember_token', 100)->nullable();
            $table->tinyInteger('confirmed')->default(0);

            $table->integer('organisation_id')->unsigned()->nullable();
            $table->foreign('organisation_id')->references('id')->on('user_organisation')->onDelete('set null');
            $table->tinyInteger('organisation_access_level')->nullable()->comment('0 - Manager, 1 - User');

            $table->string('country', 5)->nullable();
            $table->string('language_code', 5)->nullable();
            $table->foreign('language_code')->references('code')->on('language')->onDelete('set null');
            $table->string('timezone')->nullable();

            $table->binary('avatar')->nullable();

            $table->tinyInteger('twofa_enabled')->default(0);
            $table->string('twofa_secret', 45)->nullable();
            $table->string('twofa_token', 45)->nullable();

            $table->bigInteger('twitter_id')->nullable();
            $table->string('twitter_handle')->nullable();
            $table->bigInteger('facebook_id')->nullable();

            $table->integer('last_active_at')->nullable();
            $table->integer('created_at');
            $table->integer('updated_at')->default(0);
        });

        // Adding user_organisation manager foreign key
        Schema::table('user_organisation', function ($table) {
            $table->foreign('owner_id')->references('id')->on('user')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        Schema::drop('user');
        DB::statement('SET FOREIGN_KEY_CHECKS=1;');
    }
}
