<?php
/**
 * Operator Setting Table Migration
 *
 * @package    Database\Migrations\v2_0_0\Beta1\User
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.0
 */
namespace Database\Migrations\v2_0_0\Beta1\User;

use DB;
use Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Class CreateOperatorSettingTable
 *
 * @package    Database\Migrations\v2_0_0\Beta1\User
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.0
 */
class CreateOperatorSettingTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('operator_setting', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->charset = 'utf8';
            $table->collation = 'utf8_unicode_ci';

            $table->increments('id')->unsigned();
            $table->integer('user_id')->unsigned();
            $table->foreign('user_id')->references('id')->on('user')->onDelete('cascade');
            $table->string('session_id', 55)->nullable();

            $table->string('template')->nullable();
            $table->longText('ticket_signature')->nullable();
            $table->tinyInteger('ticket_reply_order')->default(0);
            $table->string('ticket_grid_columns');
            $table->integer('ticket_grid_ordering')->default(0);

            $table->string('email_notifications');
            $table->smallInteger('display_notifications')->default(1);

            $table->longText('widget_notes')->nullable()->default(null);

            $table->integer('created_at');
            $table->integer('updated_at')->default(0);
        });

        DB::statement('ALTER TABLE `operator_setting` ADD UNIQUE `unique_index`(`user_id`);');
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        Schema::drop('operator_setting');
        DB::statement('SET FOREIGN_KEY_CHECKS=1;');
    }
}
