<?php
/**
 * Update Email Batch Table Migration
 *
 * @package    Database\Migrations\v2_0_0\Beta2\Core
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.0
 */
namespace Database\Migrations\v2_0_0\Beta2\Core;

use Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Class UpdateEmailBatchTable200Beta2
 *
 * @package    Database\Migrations\v2_0_0\Beta2\Core
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.0
 */
class UpdateEmailBatchTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('email_batch', function (Blueprint $table) {
            // Drop old columns
            $table->dropColumn('from_name');
            $table->dropColumn('from_email');
            $table->dropColumn('subject');
            $table->dropColumn('contents');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('email_batch', function (Blueprint $table) {
            // Add columns back
            $table->string('from_name')->after('id');
            $table->string('from_email')->after('from_name');
            $table->string('subject')->after('from_email');
            $table->longText('contents')->after('subject');
        });
    }
}
