<?php
/**
 * Update Email Queue Table Migration
 *
 * @package    Database\Migrations\v2_0_0\Beta2\Core
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.0
 */
namespace Database\Migrations\v2_0_0\Beta2\Core;

use Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Class UpdateEmailQueueTable200Beta2
 *
 * @package    Database\Migrations\v2_0_0\Beta2\Core
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.0
 */
class UpdateEmailQueueTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('email_queue', function (Blueprint $table) {
            // Change columns
            $table->bigIncrements('id')->change();
            $table->integer('batch_id')->unsigned()->nullable()->change();

            // Drop old columns and foreign keys
            $table->dropForeign('email_queue_user_id_foreign');
            $table->dropColumn('user_id');
            $table->dropForeign('email_queue_ticket_id_foreign');
            $table->dropColumn('ticket_id');
            $table->dropColumn('user_email');

            // Add new columns
            $table->string('from_name')->after('batch_id');
            $table->string('from_email')->after('from_name');
            $table->text('to')->after('from_email');
            $table->text('cc')->after('to')->nullable();
            $table->string('subject')->after('cc');
            $table->longText('contents')->after('subject');
            $table->integer('attempts')->default(0);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        // For some fucked up reason, ALTER TABLE drop runs after the add column commands. Despite the fact,
        // dropColumns() is defined earlier in the code.
        //
        // This was the only way to fix it.
        Schema::table('email_queue', function (Blueprint $table) {
            // Drop columns.
            $table->dropColumn(['to', 'from_name', 'from_email', 'subject', 'contents', 'attempts']);
        });

        Schema::table('email_queue', function (Blueprint $table) {
            // Change columns back
            $table->increments('id')->unsigned()->change();
            $table->integer('batch_id')->unsigned()->change();

            // Add columns back
            $table->integer('user_id')->unsigned()->nullable()->after('batch_id');
            $table->foreign('user_id')->references('id')->on('user')->onDelete('cascade');
            $table->integer('ticket_id')->unsigned()->nullable()->after('user_id');
            $table->foreign('ticket_id')->references('id')->on('ticket')->onDelete('cascade');
            $table->string('user_email')->nullable()->after('ticket_id');
        });
    }
}
