<?php
/**
 * Email Queue Attachments Table Migration
 *
 * @package    Database\Migrations\v2_0_0\Beta2\Core
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.0
 */
namespace Database\Migrations\v2_0_0\Beta2\Core;

use DB;
use Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Class CreateEmailQueueAttachmentsTable
 *
 * @package    Database\Migrations\v2_0_0\Beta2\Core
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.0
 */
class CreateEmailQueueAttachmentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('email_queue_attachments', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->charset = 'utf8';
            $table->collation = 'utf8_unicode_ci';

            $table->bigInteger('queue_id')->unsigned();
            $table->foreign('queue_id')->references('id')->on('email_queue')->onDelete('cascade');

            $table->integer('upload_id')->unsigned();
            $table->foreign('upload_id')->references('id')->on('upload')->onDelete('cascade');

            $table->string('original_name');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        Schema::drop('email_queue_attachments');
        DB::statement('SET FOREIGN_KEY_CHECKS=1;');
    }
}
