<?php
/**
 * Update Scheduled Task Table Migration
 *
 * @package    Database\Migrations\v2_0_0\Beta2\Core
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.0
 */
namespace Database\Migrations\v2_0_0\Beta2\Core;

use App\Modules\Core\Models\ScheduledTask;
use Illuminate\Database\Migrations\Migration;

/**
 * Class UpdateScheduledTaskTable200Beta2
 *
 * @package    Database\Migrations\v2_0_0\Beta2\Core\Migrations\v2_0_0\Beta2\Core
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.0
 */
class UpdateScheduledTaskTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Update scheduled task
        $task = ScheduledTask::where('class', 'LIKE', '%EmailBatch')->first();
        if (!empty($task)) {
            $task->name = 'Process email queue';
            $task->description = 'Processes pending emails in the queue waiting to be sent.';
            $task->class = 'App\Modules\Core\Models\EmailQueue';
            $task->save();
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        // Revert scheduled task
        $task = ScheduledTask::where('class', 'LIKE', '%EmailQueue')->first();
        if (!empty($task)) {
            $task->name = 'Process mass emails';
            $task->description = 'Processes pending batches of a mass email waiting to be sent.';
            $task->class = 'App\Modules\Core\Models\EmailBatch';
            $task->save();
        }
    }
}
