<?php
/**
 * UpdateTicket Message Table Migration
 *
 * @package    Database\Migrations\v2_0_0\Beta2\Ticket
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.0
 */
namespace Database\Migrations\v2_0_0\Beta2\Ticket;

use App\Modules\Ticket\Models\Message;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Schema;

/**
 * Class UpdateTicketMessageTable200Beta2
 *
 * @package    Database\Migrations\v2_0_0\Beta2\Ticket
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.0
 */
class UpdateTicketMessageTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('ticket_message', function (Blueprint $table) {
            // Change columns
            $table->integer('user_id')->unsigned()->nullable()->change();

            // Update foreign key
            $table->dropForeign('ticket_message_user_id_foreign');
            $table->foreign('user_id')->references('id')->on('user')->onDelete('set null');

            // Add new columns
            $table->string('user_name')->after('user_id');
        });

        // Set user_name field for existing messages
        $messages = Message::with('user')->get([ 'id', 'user_id' ]);
        foreach ($messages as $message) {
            $message->user_name = $message->user->firstname . " " . $message->user->lastname;
            $message->save();
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('ticket_message', function (Blueprint $table) {
            // Change columns back
            $table->integer('user_id')->unsigned()->change();

            // Update foreign key
            $table->dropForeign('ticket_message_user_id_foreign');
            $table->foreign('user_id')->references('id')->on('user')->onDelete('cascade');

            // Drop new columns
            $table->dropColumn('user_name');
        });
    }
}
