<?php
/**
 * Update Ticket Table Migration
 *
 * @package    Database\Migrations\v2_0_0\Beta2\Ticket
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.0
 */
namespace Database\Migrations\v2_0_0\Beta2\Ticket;

use App\Modules\Ticket\Models\DepartmentEmail;
use App\Modules\Ticket\Models\Ticket;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Schema;

/**
 * Class UpdateTicketTable200Beta2
 *
 * @package    Database\Migrations\v2_0_0\Beta2\Ticket
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.0
 */
class UpdateTicketTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('ticket', function (Blueprint $table) {
            // Add new columns
            $table->integer('department_email_id')->unsigned()->nullable()->after('department_email');
            $table->foreign('department_email_id')->references('id')->on('department_email')->onDelete('set null');
        });

        // Fill in new column using current data
        $tickets = Ticket::whereNotNull('department_email')->get();
        foreach ($tickets as $ticket) {
            $email = DepartmentEmail::where('address', 'LIKE', $ticket->department_email)->first([ 'id' ]);
            if (!empty($email)) {
                $ticket->department_email_id = $email->id;
                $ticket->save();
            }
        }
        
        Schema::table('ticket', function (Blueprint $table) {
            // Drop old columns
            $table->dropColumn('department_email');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('ticket', function (Blueprint $table) {
            // Add columns back
            $table->string('department_email')->nullable()->after('department_email_id');
        });

        // Fill in old column using current data
        $tickets = Ticket::with('departmentEmail')
            ->whereNotNull('department_email_id')
            ->get();
        foreach ($tickets as $ticket) {
            $ticket->department_email = $ticket->departmentEmail->address;
            $ticket->save();
        }

        Schema::table('ticket', function (Blueprint $table) {
            // Drop new columns and foreign keys
            $table->dropForeign('ticket_department_email_id_foreign');
            $table->dropColumn('department_email_id');
        });
    }
}
