<?php
/**
 * Update User Organisation Table Migration
 *
 * @package    Database\Migrations\v2_0_0\Beta2\User
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.0
 */
namespace Database\Migrations\v2_0_0\Beta2\User;

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Schema;

/**
 * Class UpdateUserOrganisationTable
 *
 * @package    Database\Migrations\v2_0_0\Beta2\User
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.0
 */
class UpdateUserOrganisationTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('user_organisation', function (Blueprint $table) {
            // Change columns
            $table->integer('owner_id')->unsigned()->unique()->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('user_organisation', function (Blueprint $table) {
            // Change columns back
            $table->integer('owner_id')->unsigned()->nullable()->change();
        });
    }
}
