<?php
/**
 * Update Operator Setting Table Migration
 *
 * @package    Database\Migrations\v2_0_0\Beta2\User
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.0
 */
namespace Database\Migrations\v2_0_0\Beta2\User;

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Schema;

/**
 * Class UpdateOperatorSettingTable
 *
 * @package    Database\Migrations\v2_0_0\Beta2\User
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.0
 */
class UpdateOperatorSettingTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('operator_setting', function (Blueprint $table) {
            // Add columns
            $table->integer('datatable_rows')->default(10)->after('ticket_grid_ordering');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('operator_setting', function (Blueprint $table) {
            // Remove new columns
            $table->dropColumn('datatable_rows');
        });
    }
}
