<?php
/**
 * Update Ticket Table Migration
 *
 * @package    Database\Migrations\v2_0_0\Beta3\Ticket
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.0
 */
namespace Database\Migrations\v2_0_0\Beta3\Ticket;

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Schema;

/**
 * Class UpdateTicketTable
 *
 * @package    Database\Migrations\v2_0_0\Beta3\Ticket
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.0
 */
class UpdateTicketTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('ticket', function (Blueprint $table) {
            // Add columns
            $table->integer('paused_time')->nullable()->after('due_time');
            $table->integer('time_while_paused')->default(0)->after('paused_time');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('ticket', function (Blueprint $table) {
            // Remove new columns
            $table->dropColumn('paused_time');
            $table->dropColumn('time_while_paused');
        });
    }
}
