<?php
/**
 * Update Ticket Followup Table Migration
 *
 * @package    Database\Migrations\v2_0_0\Beta3\Ticket
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.0
 */
namespace Database\Migrations\v2_0_0\Beta3\Ticket;

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Schema;

/**
 * Class UpdateTicketFollowupTable
 *
 * @package    Database\Migrations\v2_0_0\Beta3\Ticket
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.0
 */
class UpdateTicketFollowupTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('ticket_followup', function (Blueprint $table) {
            // Rename column
            $table->renameColumn('freeze_sla', 'pause_due_time');

            // Remove column no longer needed
            $table->dropColumn('sla_time_left');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('ticket_followup', function (Blueprint $table) {
            // Rename column back
            $table->renameColumn('pause_due_time', 'freeze_sla');
        });

        Schema::table('ticket_followup', function (Blueprint $table) {
            // Add columns back
            $table->integer('sla_time_left')->nullable()->after('freeze_sla');
        });
    }
}
