<?php
/**
 * Update Schedule Hours Table Migration
 *
 * @package    Database\Migrations\v2_0_0\Ticket
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.0
 */
namespace Database\Migrations\v2_0_0\Ticket;

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Schema;

/**
 * Class UpdateScheduleHoursTable
 *
 * @package    Database\Migrations\v2_0_0\Ticket
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.0
 */
class UpdateScheduleHoursTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('schedule_hours', function (Blueprint $table) {
            // Add unique index
            $table->unique([ 'schedule_id', 'day' ]);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('schedule_hours', function (Blueprint $table) {
            // Need to drop foreign index first
            $table->dropForeign('schedule_hours_schedule_id_foreign');
            // Remove unique index
            $table->dropUnique('schedule_hours_schedule_id_day_unique');
            // Add foreign index back
            $table->foreign('schedule_id')->references('id')->on('schedule');
        });
    }
}
