<?php
/**
 * Update Sla Priority Time Table Migration
 *
 * @package    Database\Migrations\v2_0_0\Ticket
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.0
 */
namespace Database\Migrations\v2_0_0\Ticket;

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Schema;

/**
 * Class UpdateSlaPriorityTimeTable
 *
 * @package    Database\Migrations\v2_0_0\Ticket
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.0
 */
class UpdateSlaPriorityTimeTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('sla_priority_time', function (Blueprint $table) {
            // Add unique index
            $table->unique([ 'plan_id', 'priority_id' ]);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('sla_priority_time', function (Blueprint $table) {
            // Need to drop foreign index first
            $table->dropForeign('sla_priority_time_plan_id_foreign');
            $table->dropForeign('sla_priority_time_priority_id_foreign');
            // Remove unique index
            $table->dropUnique('sla_priority_time_plan_id_priority_id_unique');
            // Add foreign index back
            $table->foreign('plan_id')->references('id')->on('sla_plan');
            $table->foreign('priority_id')->references('id')->on('ticket_priority');
        });
    }
}
