<?php
/**
 * Update User Group Table Migration
 *
 * @package    Database\Migrations\v2_0_0\User
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.0
 */
namespace Database\Migrations\v2_0_0\User;

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Schema;

/**
 * Class UpdateUserGroupTable
 *
 * @package    Database\Migrations\v2_0_0\User
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.0
 */
class UpdateUserGroupTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('user_group', function (Blueprint $table) {
            // Add unique index
            $table->dropUnique('user_group_name_unique');
            $table->unique([ 'name', 'administrator' ]);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('user_group', function (Blueprint $table) {
            // Remove unique index
            $table->dropUnique('user_group_name_administrator_unique');
            // Add the original unique index back.
            $table->unique('name');
        });
    }
}
