<?php
/**
 * Operator Setting Table Migration
 *
 * @package    Database\Migrations\v2_0_0\Beta1\User
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.1
 */
namespace Database\Migrations\v2_0_1\User;

use Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Class UpdateOperatorSettingTable
 *
 * @package    Database\Migrations\v2_0_1\User
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.1
 */
class UpdateOperatorSettingTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('operator_setting', function (Blueprint $table) {
            // Add columns
            $table->string('widget_version_check')->nullable()->after('widget_notes');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('operator_setting', function (Blueprint $table) {
            // Remove new columns
            $table->dropColumn('widget_version_check');
        });
    }
}
