<?php
/**
 * File 2016_06_08_152200_update_failed_login_table.php
 *
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.2
 */
namespace Database\Migrations\v2_0_2\Core;

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Schema;

/**
 * Class UpdateFailedLoginTable
 *
 * @package    Database\Migrations\v2_0_2\Core
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.2
 */
class UpdateFailedLoginTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('failed_login', function (Blueprint $table) {
            $table->tinyInteger('event')->default(0)->after('user_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('failed_login', function (Blueprint $table) {
            $table->dropColumn([ 'event' ]);
        });
    }
}
