<?php
/**
 * Plugin Role Table Migration
 *
 * @package    Database\Migrations\v2_0_2\Core
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.2
 */
namespace Database\Migrations\v2_0_0\Beta1\User;

use DB;
use Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Class CreatePluginRoleTable
 *
 * @package    Database\Migrations\v2_0_2\Core
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.2
 */
class CreatePluginRoleTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('plugin_role', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->collation = 'utf8_unicode_ci';
            $table->charset = 'utf8';

            $table->integer('plugin_id')->unsigned();
            $table->foreign('plugin_id')->references('id')->on('plugin')->onDelete('cascade');

            $table->integer('role_id')->unsigned();
            $table->foreign('role_id')->references('id')->on('role')->onDelete('cascade');

            $table->tinyInteger('permission')->default(1);

            $table->unique([ 'plugin_id', 'role_id' ]);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        Schema::drop('plugin_role');
        DB::statement('SET FOREIGN_KEY_CHECKS=1;');
    }
}
