<?php
/**
 * File 2016_06_24_170600_update_merge_log_table.php
 *
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.2
 */
namespace Database\Migrations\v2_0_2\Ticket;

use DB;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Schema;

/**
 * Class UpdateMergeLogTable
 *
 * @package    Database\Migrations\v2_0_2\Ticket
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.2
 */
class UpdateMergeLogTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Delete any entries for tickets tha no longer exist
        DB::table('merge_log')
            ->leftJoin('ticket', 'merge_log.ticket_id', '=', 'ticket.id')
            ->whereNull('ticket.number')
            ->delete();

        Schema::table('merge_log', function (Blueprint $table) {
            $table->foreign('ticket_id')->references('id')->on('ticket')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('merge_log', function (Blueprint $table) {
            $table->dropForeign([ 'ticket_id' ]);
        });
    }
}
