<?php
/**
 * Canned Response Tag Membership Table Migration
 *
 * @package    Database\Migrations\v2_0_3\Ticket
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.3
 */
namespace Database\Migrations\v2_0_3\Ticket;

use DB;
use Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Class CreateCannedResponseTagMembershipTable
 *
 * @package    Database\Migrations\v2_0_3\Ticket
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.3
 */
class CreateCannedResponseTagMembershipTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('canned_response_tag_membership', function (Blueprint $table) {
            $table->engine = 'InnoDB';

            $table->charset = 'utf8';
            $table->collation = 'utf8_unicode_ci';

            $table->integer('response_id')->unsigned();
            $table->foreign('response_id')->references('id')->on('canned_response')->onDelete('cascade');

            $table->integer('tag_id')->unsigned();
            $table->foreign('tag_id')->references('id')->on('canned_response_tag')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        Schema::drop('canned_response_tag_membership');
        DB::statement('SET FOREIGN_KEY_CHECKS=1;');
    }
}
