<?php
/**
 * File 2016_07_29_171901_create_mass_email_table.php
 *
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.3
 */
namespace Database\Migrations\v2_0_3\User;

use DB;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Schema;

/**
 * Class CreateMassEmailTable
 *
 * @package    Database\Migrations\v2_0_3\User
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.3
 */
class CreateMassEmailTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('mass_email', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->charset = 'utf8';
            $table->collation = 'utf8_unicode_ci';

            $table->increments('id')->unsigned();

            $table->string('from_name');
            $table->string('from_email');

            $table->string('subject');
            $table->longText('contents');

            $table->integer('batch_id')->unsigned();
            $table->foreign('batch_id')->references('id')->on('email_batch')->onDelete('cascade');

            $table->unsignedTinyInteger('all_users')->default(0);
            $table->unsignedTinyInteger('all_operators')->default(0);

            $table->unsignedTinyInteger('sent')->default(0);

            $table->integer('created_at');
            $table->integer('updated_at')->default(0);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        Schema::drop('mass_email');
        DB::statement('SET FOREIGN_KEY_CHECKS=1;');
    }
}
