<?php
/**
 * File 2016_07_29_171902_create_mass_email_queue_table.php
 *
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.3
 */
namespace Database\Migrations\v2_0_3\User;

use DB;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Schema;

/**
 * Class CreateMassEmailQueueTable
 *
 * @package    Database\Migrations\v2_0_3\User
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.3
 */
class CreateMassEmailQueueTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('mass_email_queue', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->charset = 'utf8';
            $table->collation = 'utf8_unicode_ci';

            $table->integer('mass_email_id')->unsigned();
            $table->foreign('mass_email_id')->references('id')->on('mass_email')->onDelete('cascade');

            $table->string('user_email');

            $table->unique([ 'mass_email_id', 'user_email' ]);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        Schema::drop('mass_email_queue');
        DB::statement('SET FOREIGN_KEY_CHECKS=1;');
    }
}
