<?php
/**
 * File 2016_08_11_171900_update_operator_setting_table.php
 *
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.3
 */
namespace Database\Migrations\v2_0_3\User;

use App\Modules\User\Models\OperatorSetting;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Schema;

/**
 * Class UpdateOperatingSettingTable
 *
 * @package    Database\Migrations\v2_0_3\User
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.3
 */
class UpdateOperatingSettingTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('operator_setting', function (Blueprint $table) {
            // Add columns
            $table->string('default_reply_options')
                ->after('ticket_reply_order');
            $table->tinyInteger('ticket_grid_ordering_direction')
                ->default(OperatorSetting::DESCENDING)
                ->after('ticket_grid_ordering');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('operator_setting', function (Blueprint $table) {
            // Remove new columns
            $table->dropColumn('default_reply_options');
            $table->dropColumn('ticket_grid_ordering_direction');
        });
    }
}
