<?php
/**
 * Operator Canned Response UsageTable Migration
 *
 * @package    Database\Migrations\v2_0_3\User
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.3
 */
namespace Database\Migrations\v2_0_3\User;

use DB;
use Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Class CreateOperatorCannedResponseUsageTable
 *
 * @package    Database\Migrations\v2_0_3\User
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.3
 */
class CreateOperatorCannedResponseUsageTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('operator_canned_response_usage', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->charset = 'utf8';
            $table->collation = 'utf8_unicode_ci';

            $table->increments('id')->unsigned();

            $table->integer('user_id')->unsigned()->nullable();
            $table->foreign('user_id')->references('id')->on('user')->onDelete('cascade');

            $table->integer('response_id')->unsigned()->nullable();
            $table->foreign('response_id')->references('id')->on('canned_response')->onDelete('cascade');

            $table->integer('times')->default(0);
            $table->integer('last_use');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        Schema::drop('operator_canned_response_usage');
        DB::statement('SET FOREIGN_KEY_CHECKS=1;');
    }
}
