<?php
/**
 * File 2016_09_12_152200_update_language_table.php
 *
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.1.0
 */
namespace Database\Migrations\v2_1_0\Core;

use DB;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Schema;

/**
 * Class UpdateLanguageTable
 *
 * @package    Database\Migrations\v2_1_0\Core
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.1.0
 */
class UpdateLanguageTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Drop 'email_template_data_language_code_foreign' INDEX and FOREIGN KEY from email_template_data
        Schema::table('email_template_data', function (Blueprint $table) {
            $table->dropForeign('email_template_data_language_code_foreign');
        });

        // Drop 'user_organisation_language_code_foreign' INDEX and FOREIGN KEY from user_organisation.
        Schema::table('user_organisation', function (Blueprint $table) {
            $table->dropForeign('user_organisation_language_code_foreign');
        });

        // DROP 'user_language_code_foreign' INDEX AND FOREIGN KEY from user
        Schema::table('user', function (Blueprint $table) {
            $table->dropForeign('user_language_code_foreign');
        });

        // Convert language code to utf8mb4_unicode_ci
        DB::unprepared("ALTER TABLE `email_template_data` CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
        DB::unprepared("ALTER TABLE `language` CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
        DB::unprepared("ALTER TABLE `user` CHANGE `language_code` `language_code` VARCHAR(5) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL;");
        DB::unprepared("ALTER TABLE `user_organisation` CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");

        // Add indexes back.
        Schema::table('email_template_data', function (Blueprint $table) {
            $table->foreign('language_code')->references('code')->on('language')->onDelete('cascade');
        });
        Schema::table('user_organisation', function (Blueprint $table) {
            $table->foreign('language_code')->references('code')->on('language')->onDelete('set null');
        });
        Schema::table('user', function (Blueprint $table) {
            $table->foreign('language_code')->references('code')->on('language')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('email_template_data', function (Blueprint $table) {
            $table->dropForeign('email_template_data_language_code_foreign');
        });

        // Drop 'user_organisation_language_code_foreign' INDEX and FOREIGN KEY from user_organisation.
        Schema::table('user_organisation', function (Blueprint $table) {
            $table->dropForeign('user_organisation_language_code_foreign');
        });

        // DROP 'user_language_code_foreign' INDEX AND FOREIGN KEY from user
        Schema::table('user', function (Blueprint $table) {
            $table->dropForeign('user_language_code_foreign');
        });

        // Convert language code to utf8_unicode_ci
        DB::unprepared("ALTER TABLE `email_template_data` CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci");
        DB::unprepared("ALTER TABLE `language` CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci");
        DB::unprepared("ALTER TABLE `user` CHANGE `language_code` `language_code` VARCHAR(5) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL;");
        DB::unprepared("ALTER TABLE `user_organisation` CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci");

        // Add indexes back.
        Schema::table('email_template_data', function (Blueprint $table) {
            $table->foreign('language_code')->references('code')->on('language')->onDelete('cascade');
        });
        Schema::table('user_organisation', function (Blueprint $table) {
            $table->foreign('language_code')->references('code')->on('language')->onDelete('set null');
        });
        Schema::table('user', function (Blueprint $table) {
            $table->foreign('language_code')->references('code')->on('language')->onDelete('set null');
        });
    }
}
