<?php
/**
 * File 2016_09_12_152204_update_upload_table.php
 *
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.1.0
 */
namespace Database\Migrations\v2_1_0\Core;

use DB;
use Illuminate\Database\Migrations\Migration;

/**
 * Class UpdateUploadTable
 *
 * @package    Database\Migrations\v2_1_0\Core
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.1.0
 */
class UpdateUploadTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        DB::unprepared("ALTER TABLE `upload` DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");

        DB::unprepared("ALTER TABLE `upload` CHANGE `filename` `filename` VARCHAR(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL;");
        DB::unprepared("ALTER TABLE `upload` CHANGE `folder` `folder` VARCHAR(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL;");
        DB::unprepared("ALTER TABLE `upload` CHANGE `mime` `mime` VARCHAR(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL;");
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        DB::unprepared("ALTER TABLE `upload` DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci");

        DB::unprepared("ALTER TABLE `upload` CHANGE `filename` `filename` VARCHAR(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL;");
        DB::unprepared("ALTER TABLE `upload` CHANGE `folder` `folder` VARCHAR(45) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL;");
        DB::unprepared("ALTER TABLE `upload` CHANGE `mime` `mime` VARCHAR(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL;");
    }
}
