<?php
/**
 * File 2016_09_12_170700_update_activity_log_table.php
 *
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.1.0
 */
namespace Database\Migrations\v2_1_0\Core;

use DB;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Schema;

/**
 * Class UpdateActivityLogTable
 *
 * @package    Database\Migrations\v2_1_0\Core
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.1.0
 */
class UpdateActivityLogTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Drop index.
        Schema::table('activity_log', function (Blueprint $table) {
            $table->dropIndex([ 'type', 'rel_id', 'section' ]);
        });

        // Reduce section length
        Schema::table('activity_log', function (Blueprint $table) {
            $table->string('section', 191)->change();
        });

        // Create index.
        Schema::table('activity_log', function (Blueprint $table) {
            $table->index([ 'type', 'rel_id', 'section' ]);
        });

        DB::unprepared("ALTER TABLE `activity_log` CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        DB::unprepared("ALTER TABLE `activity_log` CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci");

        // Drop index.
        Schema::table('activity_log', function (Blueprint $table) {
            $table->dropIndex([ 'type', 'rel_id', 'section' ]);
        });

        // Reduce section length
        Schema::table('activity_log', function (Blueprint $table) {
            $table->string('section', 255)->change();
        });

        // Create index.
        Schema::table('activity_log', function (Blueprint $table) {
            $table->index([ 'type', 'rel_id', 'section' ]);
        });
    }
}
