<?php
/**
 * File 2016_10_07_199293_update_company_table.php
 *
 * @package    Database\Migrations\v2_0_1\Core
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.1.0
 */
namespace Database\Migrations\v2_0_1\Core;

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Schema;

/**
 * Class UpdateCompanyTable
 *
 * @package    Database\Migrations\v2_0_1\Core
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.1.0
 */
class UpdateCompanyTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::rename('company', 'brand');

        Schema::table('brand', function (Blueprint $table) {
            $table->tinyInteger('enabled')->default(1)->after('name');

            $table->string('system_url')->after('enabled');
            $table->string('frontend_logo')->nullable()->after('system_url');
            $table->string('frontend_template')->default('default')->after('frontend_logo');

            $table->string('default_email')->after('frontend_template');
            $table->string('email_method')->default('default')->after('global_email_footer');
            $table->string('smtp_host')->nullable()->after('email_method');
            $table->unsignedSmallInteger('smtp_port')->nullable()->after('smtp_host');
            $table->string('smtp_encryption')->nullable()->after('smtp_port');
            $table->tinyInteger('smtp_requires_auth')->nullable()->after('smtp_encryption');
            $table->string('smtp_username')->nullable()->after('smtp_requires_auth');
            $table->string('smtp_password', 510)->nullable()->after('smtp_username');

            $table->string('default_country')->default('default')->after('smtp_password');
            $table->string('default_timezone')->default('default')->after('default_country');
            $table->string('date_format')->default('default')->after('default_timezone');
            $table->string('time_format')->default('default')->after('date_format');
            $table->string('default_language')->default('default')->after('time_format');
            $table->tinyInteger('language_toggle')->default(2)->after('default_language');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('brand', function (Blueprint $table) {
            $table->dropColumn([
                'system_url', 'frontend_logo', 'frontend_template', 'default_email',
                'email_method', 'smtp_host', 'smtp_port', 'smtp_encryption',
                'smtp_requires_auth', 'smtp_username', 'smtp_password',
                'default_country', 'default_timezone', 'date_format', 'time_format',
                'default_language', 'language_toggle'
            ]);
        });

        Schema::rename('brand', 'company');
    }
}
