<?php
/**
 * File 2016_10_31_198814_update_email_queue_table.php
 *
 * @package    Database\Migrations\v2_1_0\Core
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.1.0
 */
namespace Database\Migrations\v2_1_0\Core;

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Schema;

/**
 * Class UpdateEmailQueueTable
 *
 * @package    Database\Migrations\v2_1_0\Core
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.1.0
 */
class UpdateEmailQueueTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('email_queue', function (Blueprint $table) {
            $table->integer('brand_id')->unsigned()->nullable()->after('id');
            $table->foreign('brand_id')->references('id')->on('brand')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('email_queue', function (Blueprint $table) {
            $table->dropForeign([ 'brand_id' ]);
            $table->dropColumn('brand_id');
        });
    }
}
