<?php
/**
 * File 2016_11_02_183118_update_email_template_data_table.php
 *
 * @package    Database\Migrations\v2_1_0\Core
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.1.0
 */
namespace Database\Migrations\v2_1_0\Core;

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Schema;

/**
 * Class UpdateEmailTemplateDataTable
 *
 * @package    Database\Migrations\v2_1_0\Core
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.1.0
 */
class UpdateEmailTemplateDataTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('email_template_data', function (Blueprint $table) {
            // NULL means default.
            $table->integer('brand_id')->unsigned()->nullable()->after('template_id');
            $table->foreign('brand_id')->references('id')->on('brand')->onDelete('cascade');

            $table->unique([ 'template_id', 'brand_id', 'language_code' ], 'tbl_unique');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('email_template_data', function (Blueprint $table) {
            $table->dropForeign([ 'brand_id' ]);
            $table->dropColumn('brand_id');

            $table->dropForeign([ 'language_code' ]);
            $table->dropForeign([ 'template_id' ]);
        });

        Schema::table('email_template_data', function (Blueprint $table) {
            $table->dropUnique('tbl_unique');
        });

        Schema::table('email_template_data', function (Blueprint $table) {
            $table->foreign('language_code')->references('code')->on('language')->onDelete('cascade');
            $table->foreign('template_id')->references('id')->on('email_template')->onDelete('cascade');
        });
    }
}
