<?php
/**
 * File 2016_11_28_189893_update_setting_table.php
 *
 * @package    Database\Migrations\v2_1_0\Core
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.1.0
 */
namespace Database\Migrations\v2_1_0\Core;

use Illuminate\Database\Migrations\Migration;
use Schema;

/**
 * Class UpdateSettingTable
 *
 * @package    Database\Migrations\v2_1_0\Core
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.1.0
 */
class UpdateSettingTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('setting', function ($table) {
            $table->string('value', 510)->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('setting', function ($table) {
            $table->string('value', 255)->change();
        });
    }
}
