<?php
/**
 * File 2016_09_12_170601_update_article_type_table.php
 *
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.1.0
 */
namespace Database\Migrations\v2_1_0\Selfservice;

use DB;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Schema;

/**
 * Class AlterArticleTypeTable
 *
 * @package    Database\Migrations\v2_1_0\Selfservice
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.1.0
 */
class AlterArticleTypeTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Drop the 'article_type_slug_unique' constraint,
        // the application logic manages this for us.
        Schema::table('article_type', function (Blueprint $table) {
            $table->dropUnique('article_type_slug_unique');
        });

        DB::unprepared("ALTER TABLE `article_type` CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        DB::unprepared("ALTER TABLE `article_type` CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci");

        // We have two article types with the same slug in our test seeds so setting unique gives problems.
        // Fetch duplicate slugs.
        $duplicateSlugs = DB::select('SELECT slug FROM `article_type` GROUP BY slug HAVING COUNT(*) > 1');

        // Prepend ID to duplicate slugs.
        DB::table('article_type')
            ->whereIn('slug', array_column($duplicateSlugs, 'slug'))
            ->update([ 'slug' => DB::raw('CONCAT(id, "-", slug)') ]);

        Schema::table('article_type', function (Blueprint $table) {
            $table->unique('slug');
        });
    }
}
