<?php
/**
 * File 2016_10_09_192939_update_article_type_table.php
 *
 * @package    Database\Migrations\v2_0_1\Selfservice
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.1.0
 */
namespace Database\Migrations\v2_1_0\Selfservice;

use App\Modules\Core\Models\Brand;
use DB;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Schema;

/**
 * Class UpdateArticleTypeTable
 *
 * @package    Database\Migrations\v2_0_1\Selfservice
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.1.0
 */
class UpdateArticleTypeTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('article_type', function (Blueprint $table) {
            $table->integer('brand_id')->unsigned()->after('id');
        });

        // Only if we have existing types (not on fresh install)
        if (DB::table('article_type')->count()) {
            DB::table('article_type')->update([ 'brand_id' => Brand::first()->id ]);
        }

        Schema::table('article_type', function (Blueprint $table) {
            $table->foreign('brand_id')->references('id')->on('brand')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('article_type', function (Blueprint $table) {
            $table->dropForeign([ 'brand_id' ]);
            $table->dropColumn('brand_id');
        });
    }
}
